#include "stdafx.h"
#include "resource.h"
#include "MessageRead.h"
#include "Mouse.h"
#include "D2Items.h"



CReadThreadParams*	pObject ;

char	theKey = 'G' ;


void parseMovement( const unsigned char *msg)
{
	BitFields move((unsigned char*)msg+1);

	DWORD unknown1 = move.GetField(15);
	DWORD posX = move.GetField(16);
	DWORD posY = move.GetField(16);
	DWORD unknown2 = move.GetField(8);
	DWORD unknown3 = move.GetField(8);

	// set the X,Y coordiniates for the where the player is
	pObject->prg->m_DropClass.m_PlayerX = posX ;
	pObject->prg->m_DropClass.m_PlayerY = posY ;

	// if any items moved out of sight, mark them invalid
	pObject->prg->m_DropClass.UpdateRange(TRUE) ;

	pObject->prg->m_DropClass.m_PreventSpam = FALSE ;
}



void parseItem( const unsigned char *msg)
{
	DWORD	areaX,
			areaY,
			itemID,
			bQuality,		// normal/rare/unique ect.
			bPosX,			// really just small ints that say where in the cube/stash/inv
			bPosY ;
	DWORD	unknown2 ;

	int iFilter = -1 ;
	DWORD itemcode ;
	DWORD goldAmount ;
	char stmp[5] ;
	CString		sItemName ;


//NOTE:  from my work on PKTK, I know this is waaaaaay wrong at times.  But good enough.


	// get info from item record messages
	if ((msg[0] == 0x9C) || (msg[0] == 0x9D)) {
/*
//		BitFields item(itemdata+((itemdata[0]==0x9c)?8:13));
		BitFields item((unsigned char*)msg+((msg[0]==0x9c)?8:13));

		DWORD flags = item.GetField(32);
		DWORD unknown1 = item.GetField(10);
		DWORD postype = item.GetField(3);

		if ((postype == 3) || (postype == 5)) {
			areaX = item.GetField(16);
			areaY = item.GetField(16);
		} else {
			DWORD bodypos = item.GetField(4);
			bPosX = item.GetField(4);
			bPosY = item.GetField(4);
			DWORD invtype = item.GetField(3);
		}

		if (flags & 0x00200000) {
			if (flags & 0x00010000) {
				DWORD unknown3 = item.GetField(3);
				DWORD unknown4 = item.GetField(7);
				DWORD unknown5;
				do {
					unknown5 = item.GetField(7);
				} while (unknown5);
			}
			itemcode = item.GetField(32);
			sprintf( stmp, "%.4s", &itemcode) ;

			if (itemcode == 0x20646C67) { //gold, *hacked test*
				DWORD goldsize = item.GetField(1);
				goldAmount = item.GetField(goldsize?32:12);
				bQuality = 1;
			}
		} else {
			itemcode = item.GetField(32);
			DWORD unknown2 = item.GetField(3);
			DWORD level = item.GetField(7);
			bQuality = item.GetField(4);
		}
*/



		BitFields item((unsigned char*)msg+((msg[0]==0x9c)?8:13));

		DWORD flags = item.GetField(32);
		DWORD unknown1 = item.GetField(10);
		DWORD postype = item.GetField(3);
		if ((postype == 3) || (postype == 5)) {
			areaX = item.GetField(16);
			areaY = item.GetField(16);
		
		} else {
			//X and Y
//NOTE: this looks like I missed the 3 bit field on the end; but it doesn't matter for
//		GI since it doesn't deal with inventory
			bPosX = item.GetField(4);
			bPosY = item.GetField(4);
		}
		itemcode = item.GetField(32);
		sprintf( stmp, "%.4s", &itemcode) ;

		if ( strcmp( "gld ", stmp) == 0) {
			DWORD goldsize = item.GetField(1);
			goldAmount = item.GetField(goldsize?32:12);
			bQuality = 1;

		} else {
			unknown2 = item.GetField(3);
			DWORD level = item.GetField(7);
			bQuality = item.GetField(4);
		}


		memcpy(&itemID,&msg[ 4],sizeof itemID);


		// if I dropped it, or another player dropped it, then don't pick it up
		if (( msg[0]==0x9C) && (msg[1]==0x02))
			if (!pObject->prg->m_GrabPlayerDrops)
				return ;



		// if this is a drop message, then set the filtering flag
		if (( msg[0]==0x9C) && (msg[1] < 0x04) && (msg[1] != 0x01)) {
			CString sOrig = stmp ;
			CString sTrimmed = sOrig ;
			sTrimmed = sTrimmed.Left(2) ;


			CArmor*		pArmor ;
			CWeapon*	pWeapon ;
			CMisc*		pMisc ;

			CString sCode = sOrig ;
			if (sOrig == "") {
				sOrig = "ear " ;
				sItemName = "ear" ;
				strcpy( stmp, "ear ") ;
				sCode = "ear " ;
				bQuality = 7 ;
			} else if (sOrig[3] == ' ') {
				sCode = sCode.Left(3) ;
			}

			pMisc = GetMiscRec( sCode) ;
			if (pMisc != NULL) {
				sItemName = pMisc->m_Name ;

			} else {
				pArmor = GetArmorRec( sCode) ;
				if (pArmor != NULL) 
					sItemName = pArmor->m_Name ;
				else {
					pWeapon = GetWeaponRec( sCode) ;
					if (pWeapon == NULL) {
						sOrig = "ear " ;
						sItemName = "ear" ;
						strcpy( stmp, "ear ") ;
						sCode = "ear " ;
						bQuality = 7 ;
					} else
						sItemName = pWeapon->m_Name ;
				}
			}

			if (sItemName == "gold") {
				CString sTmp ;
				sTmp.Format("%d gold", goldAmount) ;
				sItemName = sTmp ;
			}
				

			// if its a rare/set/unique, then supercede any other filters
			//	make sure it is NOT one of the mundane items from misc.txt (A0)
			if ((bQuality >= 5) && (bQuality <=7) && (msg[10] != 0xA0)) {
				iFilter = -2 ;	// we don't want to be added to the normal drop list

				if ((sOrig == "ear ") && (!pObject->prg->m_GrabEars)) {
					iFilter = -1 ;

				} else {
					pObject->prg->m_DropClass.GetPosFromMem() ;
				
					CUberDrop* newUber = new CUberDrop ;
						
					newUber->m_SendMsg[0] = 0x16;
					newUber->m_SendMsg[1] = 0x04;
					newUber->m_SendMsg[2] = 0x00;
					newUber->m_SendMsg[3] = 0x00;
					newUber->m_SendMsg[4] = 0x00;
					newUber->m_SendMsg[5] = msg[4];
					newUber->m_SendMsg[6] = msg[5];
					newUber->m_SendMsg[7] = msg[6];
					newUber->m_SendMsg[8] = msg[7];
					newUber->m_SendMsg[9] = 0x00;
					newUber->m_SendMsg[10] = 0x00;
					newUber->m_SendMsg[11] = 0x00;
					newUber->m_SendMsg[12] = 0x00;

					newUber->m_ItemID = itemID ;
					newUber->m_X = areaX ;
					newUber->m_Y = areaY ;
					newUber->m_Valid = TRUE ;
					newUber->m_Range = pObject->prg->m_DropClass.GetRange( areaX, areaY) ;
					newUber->m_MaxRange = pObject->prg->m_FilterNEW.m_Filter[ ITEM_UBER].m_MaxPickRange ;
					newUber->m_BeenExamined = FALSE ;
//					newUber->m_BeenDelayed = FALSE ;
//					newUber->m_FailCount = 0 ;



					// randomly choose the penalty length
					if (sItemName == "ear")
						newUber->m_DelayRemaining = 0 ;

					// if they didn't disable the penalty option, screw 'em!
					else if ( pObject->prg->m_Penalty)
						newUber->m_DelayRemaining = (rand() % 5)*1000 ;

					// no penalty
					else
						newUber->m_DelayRemaining = 0 ;

					// don't add if we are in passive mode
					if ( !pObject->prg->m_Passive) {
						pObject->prg->m_DropClass.m_DropsUber.AddTail( newUber) ;
						pObject->prg->m_DropClass.m_NumValidUbers++ ;
					}


					char tmp[80] ;
					if (sItemName == "ear") {
						sprintf( tmp, "%s", sItemName) ;
						if (pObject->prg->m_FilterNEW.m_Filter[ ITEM_UBER].m_PriorityColor > 0)
							PrintMessage( tmp, pObject->prg->m_PriorityColor[pObject->prg->m_FilterNEW.m_Filter[ ITEM_UBER].m_PriorityColor - 1] ) ;

					} else {
						switch (bQuality) {
						case 5: sItemName = "SET ITEM " + sItemName ;  break ;
						case 6: sItemName = "RARE " + sItemName ;  break ;
						case 7: sItemName = "UNIQUE " + sItemName ;  break ;
						} ;

						// print what the item is and where (as long as coordinates are ok)
						//	and as long as we want to actually print the message
						if (pObject->prg->m_FilterNEW.m_Filter[ ITEM_UBER].m_PriorityColor > 0) {
							int iClockPos = pObject->prg->m_DropClass.GetClockPos( areaX, areaY) ;
							if (iClockPos < 100)
								sprintf( tmp, "%s - %d yards away at %d o'clock - %d second penalty", sItemName, newUber->m_Range, iClockPos, newUber->m_DelayRemaining/1000) ;
							else
								sprintf( tmp, "%s - location N/A - %d second penalty", sItemName, newUber->m_DelayRemaining/1000) ;
							PrintMessage( tmp, pObject->prg->m_PriorityColor[pObject->prg->m_FilterNEW.m_Filter[ ITEM_UBER].m_PriorityColor - 1] ) ;
						}
					}

					// if we are in passive mode, then clean up our memory
					if ( pObject->prg->m_Passive)
						delete newUber ;
				}

			// gold
			} else if ( strcmp( stmp, "gld ") == 0) {

				for (int i=ITEM_GOLD1; i<=ITEM_GOLD5; i++) {
					// see if its a valid filter and this amount is of that value or better
					if (( pObject->prg->m_FilterNEW.m_Filter[ i].m_FilterValue != 0) && 
						( pObject->prg->m_FilterNEW.m_Filter[ i].m_MaxPickRange > 0) &&
						( (int)goldAmount >= pObject->prg->m_FilterNEW.m_Filter[ i].m_FilterValue)) {

						iFilter = i ;
					}
				}

			// healing pots
			} else if ( sTrimmed == "hp") {
				if ( strcmp( stmp, "hp1 ") == 0)
					iFilter = ITEM_HEALING1 ;
				else if ( strcmp( stmp, "hp2 ") == 0)
					iFilter = ITEM_HEALING2 ;
				else if ( strcmp( stmp, "hp3 ") == 0)
					iFilter = ITEM_HEALING3 ;
				else if ( strcmp( stmp, "hp4 ") == 0)
					iFilter = ITEM_HEALING4 ;
				else if ( strcmp( stmp, "hp5 ") == 0)
					iFilter = ITEM_HEALING5 ;

			// mana pots
			} else if ( sTrimmed == "mp") {
				if ( strcmp( stmp, "mp1 ") == 0)
					iFilter = ITEM_MANA1 ;
				else if ( strcmp( stmp, "mp2 ") == 0)
					iFilter = ITEM_MANA2 ;
				else if ( strcmp( stmp, "mp3 ") == 0)
					iFilter = ITEM_MANA3 ;
				else if ( strcmp( stmp, "mp4 ") == 0)
					iFilter = ITEM_MANA4 ;
				else if ( strcmp( stmp, "mp5 ") == 0)
					iFilter = ITEM_MANA5 ;

			// rejuvi pots
			} else if ( sTrimmed == "rv") {
				if ( strcmp( stmp, "rvs ") == 0)
					iFilter = ITEM_REJUV1 ;
				else if ( strcmp( stmp, "rvl ") == 0)
					iFilter = ITEM_REJUV2 ;

			// runes 01 to 33
			} else if (( sTrimmed == "r0") || ( sTrimmed == "r1") || 
					   ( sTrimmed == "r2") || ( sTrimmed == "r3")) {
				CString sRune = stmp ;
				sRune = sRune.Mid( 1, 2) ;
				int	iRune = atoi( sRune) ;

				for (int i=ITEM_RUNE1; i<=ITEM_RUNE5; i++) {
					// see if its a valid filter and this rune is of that quality or better
					if (( pObject->prg->m_FilterNEW.m_Filter[ i].m_FilterValue != 0) && 
						( pObject->prg->m_FilterNEW.m_Filter[ i].m_MaxPickRange > 0) &&
						( iRune >= pObject->prg->m_FilterNEW.m_Filter[ i].m_FilterValue)) {

						iFilter = i ;
					}
				}

			// jewlry
			} else if ( strcmp( stmp, "rin ") == 0) {
				iFilter = ITEM_JEWLRY ;
			} else if ( strcmp( stmp, "amu ") == 0) {
				iFilter = ITEM_JEWLRY ;

			// friggin glavies mess up gems and take the name that a flawless amyethst wants
			} else if ( strcmp( stmp, "glv ") == 0) {
				iFilter = -1 ;

			// gems - EXCEPT for flawless Amyethsts
			} else if (( sTrimmed == "gc") || ( sTrimmed == "gf") || ( sTrimmed == "gs") ||
					   ( sTrimmed == "gl") || ( sTrimmed == "gp")) {
				CString sGem = sOrig.Right(2) ;
				if (( sGem == "b ") || ( sGem == "g ") || ( sGem == "r ") || 
					   ( sGem == "v ") || ( sGem == "y ") || ( sGem == "w ")) {
					if ( sTrimmed == "gc") { 
						iFilter = ITEM_GEM1 ;
					} else if ( sTrimmed == "gf") { 
						iFilter = ITEM_GEM2 ;
					} else if ( sTrimmed == "gs") { 
						iFilter = ITEM_GEM3 ;
					} else if ( sTrimmed == "gl") { 
						iFilter = ITEM_GEM4 ;
					} else if ( sTrimmed == "gp") { 
						iFilter = ITEM_GEM5 ;
					}
				}

			// flawless amyethsts (they don't conform)
			} else if ( strcmp( stmp, "gzv ") == 0) { 
				iFilter = ITEM_GEM4 ;

			//skulls
			} else if ( sTrimmed == "sk") { 
				if ( strcmp( stmp, "skc ") == 0)
					iFilter = ITEM_SKULL1 ;
				else if ( strcmp( stmp, "skf ") == 0)
					iFilter = ITEM_SKULL2 ;
				else if ( strcmp( stmp, "sku ") == 0)
					iFilter = ITEM_SKULL3 ;
				else if ( strcmp( stmp, "skl ") == 0)
					iFilter = ITEM_SKULL4 ;
				else if ( strcmp( stmp, "skz ") == 0)
					iFilter = ITEM_SKULL5 ;

			// jewels
			} else if ( strcmp( stmp, "jew ") == 0) { 
				iFilter = ITEM_JEWELS ;
				
			// charms
			} else if ( sTrimmed == "cm") { 
				if ( strcmp( stmp, "cm1 ") == 0)
					iFilter = ITEM_CHARMS ;
				else if ( strcmp( stmp, "cm2 ") == 0)
					iFilter = ITEM_CHARMS ;
				else if ( strcmp( stmp, "cm3 ") == 0)
					iFilter = ITEM_CHARMS ;
				
			// TP scrolls
			} else if ( strcmp( stmp, "tsc ") == 0) { 
				iFilter = ITEM_TP ;

			// ID scrolls
			} else if ( strcmp( stmp, "isc ") == 0) { 
				iFilter = ITEM_ID ;


			// didn't match, so keep as uninitialized
			} else {
				iFilter = -1 ;
			}
		}		

	// the item pick up message
	} else {
		memcpy(&itemID,&msg[ 2],sizeof itemID);
	}


/*
if ( strcmp( stmp, "gld ") == 0) {
FILE* fmouse = fopen("dump.txt","a") ;
fprintf( fmouse, "%X   textcode: %.4s   tx hex: %.4X   m_bQuality:  %d\n", msg[0], &itemcode, itemcode, bQuality);
fclose( fmouse) ;
}
*/

/*
9c 00 = monster drop and come within sight range notice
9c 01 = me pick up from ground and float
9c 02 = player (or me) drop on ground
9c 03 = stuff is here on ground when you come into range of it
9c 04 = me put into inv

9d 05 = me pick from inv
9d 06 = player wearing item
*/


	if ((( msg[0]==0x9C) && (msg[1] < 0x04) && (msg[1] != 0x01)) && (( iFilter == -1) || 
		       (pObject->prg->m_FilterNEW.m_Filter[ iFilter].m_MaxPickRange == 0))) {
		char tmp[80] ;
		sprintf( tmp, "%s - >%s<", sItemName, stmp) ;
		PrintMessage( tmp, pObject->prg->m_ColorNot) ;

	// load item into our pick-up list if this was a "within sight" message and
	//   if the filter has a range greater than 0, then we want this item
	//   make sure the filter was also init to something other than -1
	} else if (( msg[0]==0x9C) && (msg[1] < 0x04) && (msg[1] != 0x01) && ( iFilter > -1) && 
		       (pObject->prg->m_FilterNEW.m_Filter[ iFilter].m_MaxPickRange > 0)) {

/*
FILE* ftemp = fopen("dump.txt", "a") ;
fprintf( ftemp, ">%.4s<  q=%d\n", &itemcode, bQuality) ;
fclose(ftemp) ;

FILE* fmouse = fopen("dump.txt","a") ;
for (unsigned int i = 0; i < msg[2]; i++)
	fprintf( fmouse,"%.2X ",msg[i]);
fprintf( fmouse,"\n\n");
fclose( fmouse) ;
*/
		CNormalDrop* newDrop = new CNormalDrop ;
			
		newDrop->m_SendMsg[0] = 0x16;
		newDrop->m_SendMsg[1] = 0x04;
		newDrop->m_SendMsg[2] = 0x00;
		newDrop->m_SendMsg[3] = 0x00;
		newDrop->m_SendMsg[4] = 0x00;
		newDrop->m_SendMsg[5] = msg[4];
		newDrop->m_SendMsg[6] = msg[5];
		newDrop->m_SendMsg[7] = msg[6];
		newDrop->m_SendMsg[8] = msg[7];
		newDrop->m_SendMsg[9] = 0x00;
		newDrop->m_SendMsg[10] = 0x00;
		newDrop->m_SendMsg[11] = 0x00;
		newDrop->m_SendMsg[12] = 0x00;

		newDrop->m_ItemID = itemID ;
		newDrop->m_X = areaX ;
		newDrop->m_Y = areaY ;
		newDrop->m_Valid = TRUE ;
		newDrop->m_Range = pObject->prg->m_DropClass.GetRange( areaX, areaY) ;
		newDrop->m_MaxRange = pObject->prg->m_FilterNEW.m_Filter[ iFilter].m_MaxPickRange ;
		newDrop->m_BeenExamined = FALSE ;
//		newDrop->m_BeenDelayed = FALSE ;
//		newDrop->m_FailCount = 0 ;

//if ((newDrop->m_Range <= 24) && (newDrop->m_Range > 20) ||
//    (newDrop->m_Range <= 15) && (newDrop->m_Range > 10) ||
//    (newDrop->m_Range <= 5) && (newDrop->m_Range >= 0)) {

		// don't add if we are in passive mode
		if ( !pObject->prg->m_Passive) {
			pObject->prg->m_DropClass.m_Drops.AddTail( newDrop) ;

			// if we know this is in range, add to our list.  if we are coming through a wp,
			//	the item will be out of sight until we get a movement packet
			if ( newDrop->m_Range <= newDrop->m_MaxRange) {
				pObject->prg->m_DropClass.m_DropsValid.AddTail( newDrop) ;
			}
			pObject->prg->m_DropClass.m_NumValidItems++ ;
		}

		// print what the item is and where (as long as coordinates are ok)
		char tmp[80] ;
//		sprintf( tmp, "%s", sItemName) ;
		int iClockPos = pObject->prg->m_DropClass.GetClockPos( areaX, areaY) ;
		if (iClockPos < 100)
			sprintf( tmp, "%s - %d yards away at %d o'clock", sItemName, newDrop->m_Range, iClockPos) ;
		else
			sprintf( tmp, "%s - location N/A", sItemName) ;
		if (pObject->prg->m_FilterNEW.m_Filter[ ITEM_UBER].m_PriorityColor > 0)
			PrintMessage( tmp, pObject->prg->m_PriorityColor[pObject->prg->m_FilterNEW.m_Filter[ iFilter].m_PriorityColor - 1] ) ;

		// if we are in passive mode, then clean up our memory
		if ( pObject->prg->m_Passive)
			delete newDrop ;



//FILE* fmouse = fopen("dump.txt","a") ;
//fprintf( fmouse,"%X added to list      m_NumValidItems: %d\n", newDrop->m_ItemID, pObject->prg->m_NumValidItems) ;
//fclose( fmouse) ;


	// it got picked up so remove from our list
	} else if (( msg[0]==0x0A) && (msg[1] == 0x04)) {

		// if the itemid of this picked up object matches something on the list, then
		//	invalid the object on the list
		for( POSITION posItem = pObject->prg->m_DropClass.m_DropsUber.GetHeadPosition(); posItem != NULL;) {
			// get the item and the next pos
			CUberDrop* pItem = (CUberDrop*)pObject->prg->m_DropClass.m_DropsValid.GetNext(posItem);

			// if the id's match, invalidate; remember: the item could be on the list
			//	multiple times if we popped it from the top and moved to the end
			if ( pItem->m_ItemID == itemID) {

				// only decrease count if this is a valid item to begin with
				if (pItem->m_Valid) {
					pObject->prg->m_DropClass.m_NumValidUbers-- ;
					pObject->prg->m_DropClass.GetPosFromMem() ;	// update our XY to reduce lagging on other items
				}
				pItem->m_Valid = FALSE ;
			}
		}


		// if the itemid of this picked up object matches something on the list, then
		//	invalid the object on the list
		for( posItem = pObject->prg->m_DropClass.m_DropsValid.GetHeadPosition(); posItem != NULL;) {
			// get the item and the next pos
			CNormalDrop* pItem = (CNormalDrop*)pObject->prg->m_DropClass.m_DropsValid.GetNext(posItem);

			// if the id's match, invalidate; remember: the item could be on the list
			//	multiple times if we popped it from the top and moved to the end
			if ( pItem->m_ItemID == itemID) {

				// only decrease count if this is a valid item to begin with
				if (pItem->m_Valid) {
					pObject->prg->m_DropClass.m_NumValidItems-- ;
					pObject->prg->m_DropClass.GetPosFromMem() ;	// update our XY to reduce lagging on other items
//FILE* fmouse = fopen("dump.txt","a") ;
//fprintf( fmouse, "%X was picked up      m_NumValidItems: %d\n", pItem->m_ItemID, pObject->prg->m_NumValidItems) ;
//fclose( fmouse) ;
				}
				pItem->m_Valid = FALSE ;
			}
		}
		pObject->prg->m_DropClass.m_PreventSpam = FALSE ;
	}
}


// this is just the messageproc for a window we open.  I'll explain why we are opening a
//	a window down in MyThreadProc.  The focus here is the WM_COPYDATA message
LRESULT CALLBACK TestWindowProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg) {
		case WM_DESTROY:
			PostQuitMessage(0);
			break;

		// if we get a wm_copydata msg, rock n' roll!!!
		case WM_COPYDATA: {

			COPYDATASTRUCT *pcds = (COPYDATASTRUCT *)lParam;
			BYTE msg[500];
			//unsigned long ul=0;
			memcpy( &msg, (const unsigned char*)pcds->lpData, pcds->cbData);

/*
if (( msg[0]==0x9C) || ( msg[0]==0x9D) || ( msg[0]==0x07)) {
FILE* fmouse = fopen("dump.txt","a") ;
for (unsigned int i = 0; i < pcds->cbData; i++)
	fprintf( fmouse,"%.2X ",msg[i]);
fprintf( fmouse,"\n");
fclose( fmouse) ;
}
*/

			if ((int)pcds->dwData >= 0) {
				pObject->prg->m_Capturing = !pObject->prg->m_Capturing ;

				if (pObject->prg->m_Capturing) {
					wchar_t szText[80] = L"\xff" L"c2GrabIt activated" ;
					SendTextToD2(szText);
				} else {
					wchar_t szText[80] = L"\xff" L"c2GrabIt off" ;
					SendTextToD2(szText);
				}
			}

			if (pObject->prg->m_Capturing) {

				if ( msg[0]==0x9C) {
					// drops and "item here" msgs - see if we should pick
					if ( msg[1] <= 0x04)
						parseItem( msg) ;

				} else if ( msg[0]==0x9D) {
					// drops and "item here" msgs - see if we should pick
					if ( msg[1] == 0x05)
						parseItem( msg) ;

				// 0A, 04 means an item was removed from the ground
				} else if ( msg[0]==0x0A) {
					if ( msg[1] == 0x04)
						parseItem( msg) ;

				// player coordinates
				} else if (msg[0] == 0x96) {
					parseMovement( msg) ;
				}
			}

			// copy the data into a seperate buffer
			break;

		}

		default:
			return DefWindowProc(hwnd, uMsg, wParam, lParam);
	}
	return 0;
}


// when you press the START button, a seperate thread (this one) is created.
//   In this thread, we just keep looking for WM_COPYDATA messages until the STOP button
//	 is pressed or the app is closed.
UINT MyThreadProc( LPVOID pParam )
{
	pObject = (CReadThreadParams*)pParam;


	// ok ok ok.  This is SLOPPY coding, but I could not figure out how to get it to work
	//	  correctly.  What I want to do is translate the WM_COPYDATA message that Mousepad
	//	  is redirecting the data from his intercept code.  The "correct" way to do this
	//	  would be to implement the WM_COPYDATA within the framework of the view class.  I
	//	  failed trying to do this.  So instead I create a small window that is invisible,
	//	  and it has its own message loop.  I can easily translate the WM_COPYDATA message
	//	  from this seperate window in a seperate thread.  UGLY!!!! But it works ;-)
	WNDCLASS wc = {0, TestWindowProc, 0, 0, GetModuleHandle(0), 0, 0, (HBRUSH)GetStockObject(BLACK_BRUSH), 0, "testwin"};
	RegisterClass(&wc);
	HWND hwnd = CreateWindow("testwin", "testwin", WS_OVERLAPPEDWINDOW, 0, 0, 100, 100, 0, 0, GetModuleHandle(0),0);


	// modify the dll in memory and insert our intercept code
	MessagesHackStart(hwnd, pObject->diablo2_ph);
	
	// keep looping until the we get a close message
	MSG lpMsg;
	while (GetMessage(&lpMsg,0,0,0)) {
		TranslateMessage(&lpMsg);
		DispatchMessage(&lpMsg);
	}

	// unload the intercept code
	MessagesHackStop( pObject->diablo2_ph) ;

	return 0;
}



